/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	WSTRUCTS.H - WAD files data structures.
*/

#ifndef WSTRUCTS_H
#define WSTRUCTS_H

/*
	data structure for the THINGS in Doom format
*/
typedef struct Thing *TPtr;
struct Thing
{
	BCINT  xpos;    /* x position */
	BCINT  ypos;    /* y position */
	BCINT  angle;   /* facing angle (0 = east, 90 = north, ...) */
	BCINT  type;    /* thing type */
	BCINT  when;    /* appears when? (bit 4 = multi-player) */
};

/*
	data structure for the THINGS in Hexen format
*/
struct ThingH
{
	UBCINT tid;     /* thing ID */
	BCINT  xpos;    /* x position */
	BCINT  ypos;    /* y position */
	BCINT  zpos;    /* z position */
	BCINT  angle;   /* facing angle (0 = east, 90 = north, ...) */
	BCINT  type;    /* thing type */
	BCINT  when;    /* appears when? (bit 4 = multi-player) */
	UBYTE  special; /* action special */
	UBYTE  arg1;    /* action argument 1 */
	UBYTE  arg2;    /* action argument 2 */
	UBYTE  arg3;    /* action argument 3 */
	UBYTE  arg4;    /* action argument 4 */
	UBYTE  arg5;    /* action argument 5 */
};

/*
	data structure for the VERTEXES
*/
typedef struct Vertex *VPtr;
struct Vertex
{
	BCINT  x;       /* X coordinate */
	BCINT  y;       /* Y coordinate */
};

/*
	data structure for the LINEDEFS in Doom format
*/
typedef struct LineDef *LDPtr;
struct LineDef
{
	UBCINT  start;    /* from this vertex ... */
	UBCINT  end;      /* ... to this vertex */
	BCINT   flags;    /* attributes (bit 0 = impassible, bit 5 = secret, ...) */
	BCINT   type;     /* type to activate special effects (39 & 97 = teleport) */
	BCINT   tag;      /* linedef activates the sector with the same tag */
	UBCINT  sidedef1; /* "right" sidedef */
	UBCINT  sidedef2; /* only if this line adjoins 2 sectors, else -1 */
};

/*
	data structure for the LINEDEFS in Hexen format
*/
struct LineDefH
{
	UBCINT start;     /* from this vertex ... */
	UBCINT end;       /* ... to this vertex */
	BCINT  flags;     /* attributes (bit 0 = impassible, bit 5 = secret, ...) */
	UBYTE  special;   /* action special */
	UBYTE  arg1;      /* action argument 1 */
	UBYTE  arg2;      /* action argument 2 */
	UBYTE  arg3;      /* action argument 3 */
	UBYTE  arg4;      /* action argument 4 */
	UBYTE  arg5;      /* action argument 5 */
	UBCINT sidedef1;  /* "right" sidedef */
	UBCINT sidedef2;  /* only if this line adjoins 2 sectors, else -1 */
};

/*
	data structure for the SIDEDEFS
*/
typedef struct SideDef *SDPtr;
struct SideDef
{
	BCINT   xoff;     /* X offset for texture */
	BCINT   yoff;     /* Y offset for texture */
	char    tex1[8];  /* texture name for the upper part */
	char    tex2[8];  /* texture name for the lower part */
	char    tex3[8];  /* texture name for the regular part */
	UBCINT  sector;   /* adjacent sector */
};

/*
	data structure for the SEGS
*/
typedef struct Seg *SEPtr;
struct Seg
{
	SEPtr   next;     /* next Seg in list */
	UBCINT  start;    /* from this vertex ... */
	UBCINT  end;      /* ... to this vertex */
	UBCINT  angle;    /* angle (0 = east, 16384 = north, ...) */
	UBCINT  linedef;  /* linedef that this seg goes along */
	BCINT   flip;     /* true if not the same direction as linedef */
	UBCINT  dist;     /* distance from starting point */
};

/*
	data structure for the SSECTORS
*/
typedef struct SSector *SSPtr;
struct SSector
{
	SSPtr  next;      /* next Sub-Sector in list */
	BCINT  num;       /* number of Segs in this Sub-Sector */
	BCINT  first;     /* first Seg */
};

/*
	data structure for the SECTORS
*/
typedef struct Sector *SPtr;
struct Sector
{
	BCINT  floorh;    /* floor height */
	BCINT  ceilh;     /* ceiling height */
	char   floort[8]; /* floor texture */
	char   ceilt[8];  /* ceiling texture */
	BCINT  light;     /* light level (0-255) */
	BCINT  special;   /* special behaviour (0 = normal, 9 = secret, ...) */
	BCINT  tag;       /* sector activated by a linedef with the same tag */
};

/*
	data structure for the NODES
*/
typedef struct Node *NPtr;
struct Node
{
	BCINT  x, y;           /* starting point */
	BCINT  dx, dy;         /* offset to ending point */
	BCINT  miny1, maxy1,
	       minx1, maxx1;   /* bounding rectangle 1 */
	BCINT  miny2, maxy2,
	       minx2, maxx2;   /* bounding rectangle 2 */
	BCINT  child1, child2; /* Node or SSector (if high bit is set) */
	NPtr   node1, node2;   /* pointer if the child is a Node */
	BCINT  num;            /* number given to this Node */
};

#endif /* WSTRUCTS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
