/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	THINGS.C - Thing routines.
*/

#include "dmmpst.h"
#include "things.h"
#include "levels.h"


/*
	the global variables
*/
UBCINT NumThClasses = 0;
ThClass **ThClasses = NULL;

UBCINT NumThItems = 0;
ThItem  **ThItems = NULL;


/* local variables */
UBCINT NumUsedLinks = 0;
char    **UsedLinks = NULL;


/* local function definitions */
void DumpThings( UBCINT);
void AppendClass( UBCINT, char *, char *, char *);
void AppendStrife( BCINT, UBCINT, UBCINT, char *, char *);
void AppendItem( UBCINT, UBCINT, char *, char *);
void SortStrife( UBCINT);


/* Strife character translation table */
typedef struct
{
	UBCINT mapnr;
	UBCINT thgid;
	char  *wikiname;
	char  *wikilink;
} StrifeChar;

#define NUMCHARS 131

StrifeChar StrifeChars[NUMCHARS] = {
	{  1, THING_PEASANTGRAY3,   "Beldin", "Strife_minor_characters_-_Hub_1#Beldin" },

	{  2, THING_ACOLYTE5DGREEN, "Sewer guard", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{  2, THING_ACOLYTE6GOLD,   "Guard (type 58)", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{  2, THING_ACOLYTE4GRAY,   "Guard (type 56)", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{  2, THING_ACOLYTE2RED,    "Door guard", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{  2, THING_ACOLYTE3RUST,   "Guard (type 55)", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{  2, THING_MEDIC,          "Medic", "Strife_minor_characters_-_Hub_1#Medic" },
	{  2, THING_ARMORER,        "Armorer", "Strife_minor_characters_-_Hub_1#Armorer" },
	{  2, THING_WEAPONSMITH,    "Weapon smith (Bowyer)", "Strife_minor_characters_-_Hub_1#Bowyer" },
	{  2, THING_BARKEEP,        "Barkeep", "Strife_minor_characters_-_Hub_1#Barkeep" },
	{  2, THING_REBEL2,         "Front guard", "Strife_minor_characters_-_Hub_1#Front_Guard" },
	{  2, THING_BEGGAR1,        "MacGuffin", "" },
	{  2, THING_PEASANTBLUE,    "Governor Mourel", "" },
	{  2, THING_PEASANTDGRN1,   "Irale", "Strife_minor_characters_-_Hub_1#Irale" },
	{  2, THING_PEASANTLGRN1,   "Sewer gate watchman", "Strife_minor_characters_-_Hub_1#Peasants" },
	{  2, THING_PEASANTRED1,    "Harris", "" },
	{  2, THING_PEASANTRUST1,   "Rowan", "" },
	{  2, THING_PEASANTRUST2,   "Geoff", "" },
	{  2, THING_PEASANTTAN2,    "Arion", "Strife_minor_characters_-_Hub_1#Arion" },
	{  2, THING_PEASANTTAN3,    "Ulaine", "Strife_minor_characters_-_Hub_1#Ulaine" },

	{  3, THING_MEDIC,          "Medic (Gerard)", "Strife_minor_characters_-_Hub_1#Gerard" },
	{  3, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife_minor_characters_-_Hub_1#Feris" },
	{  3, THING_REBEL2,         "Rebel (type 44)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{  3, THING_REBEL3,         "Rebel (type 45)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{  3, THING_REBEL4,         "Rebel (type 46)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{  3, THING_REBEL5,         "Rebel (type 47)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{  3, THING_REBEL6,         "Rebel (type 48)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{  3, THING_PEASANTDGRN1,   "Peasant (type 18)", "Strife_minor_characters_-_Hub_1#Peasants_2" },
	{  3, THING_PEASANTGRAY1,   "Advisor (type 12)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{  3, THING_PEASANTGRAY2,   "Macil's advisor (type 13)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{  3, THING_PEASANTGRAY3,   "Advisor (type 14)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{  3, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife_minor_characters_-_Hub_1#Peasants_2" },
	{  3, THING_PEASANTRUST2,   "Peasant (type 16)", "Strife_minor_characters_-_Hub_1#Peasants_2" },
	{  3, THING_PEASANTRUST3,   "Peasant (type 17)", "Strife_minor_characters_-_Hub_1#Peasants_2" },

	{  4, THING_ACOLYTE5DGREEN, "Overseer", "Strife_minor_characters_-_Hub_1#Acolytes_2" },
	{  4, THING_ACOLYTE6GOLD,   "Core guard", "Strife_minor_characters_-_Hub_1#Acolytes_2" },
	{  4, THING_ACOLYTE4GRAY,   "Reactor guard", "Strife_minor_characters_-_Hub_1#Acolytes_2" },
	{  4, THING_ACOLYTE2RED,    "Door guard", "Strife_minor_characters_-_Hub_1#Acolytes_2" },
	{  4, THING_ACOLYTE3RUST,   "Foreman", "Strife_minor_characters_-_Hub_1#Acolytes_2" },
	{  4, THING_PEASANTGRAY1,   "Ketrick", "Strife_minor_characters_-_Hub_1#Ketrick" },
	{  4, THING_PEASANTGRAY2,   "Sammis", "Strife_minor_characters_-_Hub_1#Sammis" },
	{  4, THING_PEASANTGRAY3,   "Computer tech (type 14)", "Strife_minor_characters_-_Hub_1#Technicians" },
	{  4, THING_PEASANTRED1,    "Dock worker (type 9)", "Strife_minor_characters_-_Hub_1#Dock_Workers" },
	{  4, THING_PEASANTRED2,    "Derwin", "" },
	{  4, THING_PEASANTRED3,    "Worner", "" },
	{  4, THING_PEASANTRUST1,   "Dock worker (type 15)", "Strife_minor_characters_-_Hub_1#Dock_Workers" },
	{  4, THING_PEASANTRUST2,   "Technician (type 16)", "Strife_minor_characters_-_Hub_1#Technicians" },
	{  4, THING_PEASANTRUST3,   "Technician (type 17)", "Strife_minor_characters_-_Hub_1#Technicians" },
	{  4, THING_PEASANTTAN2,    "Technician (type 7)", "Strife_minor_characters_-_Hub_1#Technicians" },
	{  4, THING_PEASANTTAN3,    "Technician (type 8)", "Strife_minor_characters_-_Hub_1#Technicians" },

	{  5, THING_ACOLYTE2RED,    "Door guard", "Strife_minor_characters_-_Hub_1#Door_Guard" },
	{  5, THING_ACOLYTE3RUST,   "Prison guard", "Strife_minor_characters_-_Hub_1#Prison_Guard" },
	{  5, THING_PEASANTDGRN1,   "Prisoner (type 18)", "Strife_minor_characters_-_Hub_1#Prisoners" },
	{  5, THING_PEASANTDGRN2,   "Prisoner (type 19)", "Strife_minor_characters_-_Hub_1#Prisoners" },
	{  5, THING_PEASANTDGRN3,   "Prisoner (type 20)", "Strife_minor_characters_-_Hub_1#Prisoners" },
	{  5, THING_PEASANTGRAY1,   "Warden Montag", "" },
	{  5, THING_PEASANTGRAY2,   "Judge Wolenick", "" },
	{  5, THING_PEASANTRUST1,   "Prisoner (type 15)", "Strife_minor_characters_-_Hub_1#Prisoners" },
	{  5, THING_PEASANTRUST2,   "Prisoner (type 16)", "Strife_minor_characters_-_Hub_1#Prisoners" },
	{  5, THING_PEASANTRUST3,   "Prisoner (type 17)", "Strife_minor_characters_-_Hub_1#Prisoners" },

	{  6, THING_ACOLYTE2RED,    "Acolyte (type 54)", "Strife_minor_characters_-_Hub_1#Acolytes_3" },
	{  6, THING_ACOLYTE3RUST,   "Watchman", "Strife_minor_characters_-_Hub_1#Acolytes_3" },
	{  6, THING_ACOLYTE1TAN,    "Acolyte (type 53)", "Strife_minor_characters_-_Hub_1#Acolytes_3" },
	{  6, THING_BEGGAR1,        "Beggar (type 38)", "Strife_minor_characters_-_Hub_1#Sewer_mutants" },
	{  6, THING_BEGGAR2,        "Beggar (type 39)", "Strife_minor_characters_-_Hub_1#Sewer_mutants" },
	{  6, THING_BEGGAR3,        "Beggar (type 40)", "Strife_minor_characters_-_Hub_1#Sewer_mutants" },
	{  6, THING_BEGGAR4,        "Beggar (type 41)", "Strife_minor_characters_-_Hub_1#Sewer_mutants" },
	{  6, THING_BEGGAR5,        "Beggar (type 42)", "Strife_minor_characters_-_Hub_1#Sewer_mutants" },
	{  6, THING_PEASANTDGRN2,   "Weran", "" },

	{  7, THING_ACOLYTE2RED,    "Acolyte (type 54)", "Strife_minor_characters_-_Hub_1#Acolytes_4" },
	{  7, THING_PEASANTLGRN1,   "False Programmer", "Strife_minor_characters_-_Hub_1#Programmer" },
	{  7, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife_minor_characters_-_Hub_1#Peasants_3" },
	{  7, THING_PEASANTTAN1,    "Peasant (type 6)", "Strife_minor_characters_-_Hub_1#Peasants_3" },

	{  8, THING_PEASANTBLUE,    "False Programmer", "Strife_minor_characters_-_Hub_1#Programmer_2" },

	{ 10, THING_MEDIC,          "Medic (Gerard)", "Strife_minor_characters_-_Hub_2#Gerard" },
	{ 10, THING_ARMORER,        "Armorer (Justin)", "Strife_minor_characters_-_Hub_2#Justin" },
	{ 10, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife_minor_characters_-_Hub_2#Feris" },
	{ 10, THING_REBEL2,         "Rebel (type 44)", "Strife_minor_characters_-_Hub_2#Rebels" },
	{ 10, THING_REBEL3,         "Rebel (type 45)", "Strife_minor_characters_-_Hub_2#Rebels" },
	{ 10, THING_REBEL4,         "Rebel (type 46)", "Strife_minor_characters_-_Hub_2#Rebels" },

	{ 11, THING_ACOLYTE4GRAY,   "Sergeant", "Strife_minor_characters_-_Hub_2#Sergeant" },
	{ 11, THING_ACOLYTE2RED,    "Temple guard", "Strife_minor_characters_-_Hub_2#Temple_Guards" },
	{ 11, THING_PEASANTGOLD1,   "Keymaster", "Strife_minor_characters_-_Hub_2#Keymaster" },
	{ 11, THING_PEASANTRUST1,   "Prisoner (type 15)", "Strife_minor_characters_-_Hub_2#Prisoners" },
	{ 11, THING_PEASANTRUST2,   "Prisoner (type 16)", "Strife_minor_characters_-_Hub_2#Prisoners" },
	{ 11, THING_PEASANTRUST3,   "Prisoner (type 17)", "Strife_minor_characters_-_Hub_2#Prisoners" },

	{ 14, THING_PEASANTGOLD1,   "Drone (type 24)", "Strife_minor_characters_-_Hub_3#Drones" },
	{ 14, THING_PEASANTGOLD2,   "Drone (type 25)", "Strife_minor_characters_-_Hub_3#Drones" },
	{ 14, THING_PEASANTGOLD3,   "Drone (type 26)", "Strife_minor_characters_-_Hub_3#Drones" },
	{ 14, THING_PEASANTRED1,    "James", "Strife_minor_characters_-_Hub_3#James" },

	{ 15, THING_ACOLYTE2RED,    "Foreman", "Strife_minor_characters_-_Hub_2#Foreman" },
	{ 15, THING_PEASANTRUST1,   "Technician (type 15)", "Strife_minor_characters_-_Hub_2#Technicians" },
	{ 15, THING_PEASANTRUST2,   "Technician (type 16)", "Strife_minor_characters_-_Hub_2#Technicians" },

	{ 17, THING_ACOLYTE5DGREEN, "Warehouse guard", "Strife_minor_characters_-_Hub_2#Warehouse_Guard" },
	{ 17, THING_ACOLYTE2RED,    "Bailey guard", "Strife_minor_characters_-_Hub_2#Bailey_Guard" },
	{ 17, THING_MEDIC,          "Medic (Quincy)", "Quincy" },
	{ 17, THING_PEASANTGRAY1,   "Assistant", "Strife_minor_characters_-_Hub_2#Assistant" },

	{ 18, THING_ACOLYTE6GOLD,   "Warehouse guard", "Strife_minor_characters_-_Hub_2#Warehouse_Guard_2" },

	{ 23, THING_MEDIC,          "Medic", "Strife_minor_characters_-_Hub_3#Medic" },
	{ 23, THING_ARMORER,        "Armorer", "Strife_minor_characters_-_Hub_3#Armorer" },
	{ 23, THING_WEAPONSMITH,    "Weapon smith", "Strife_minor_characters_-_Hub_3#Weapon_Smith" },
	{ 23, THING_BARKEEP,        "Barkeep", "Strife_minor_characters_-_Hub_3#Barkeep" },
	{ 23, THING_PEASANTDGRN1,   "Richter", "" },
	{ 23, THING_PEASANTGOLD1,   "Timothy", "Strife_minor_characters_-_Hub_3#Timothy" },
	{ 23, THING_PEASANTRED1,    "Tevick", "Strife_minor_characters_-_Hub_3#Tevick" },

	{ 27, THING_PEASANTGRAY1,   "Loremaster's slave", "Strife_minor_characters_-_Hub_3#Peasant" },

	{ 31, THING_PEASANTGOLD1,   "False Programmer", "Strife_minor_characters_-_Hub_1#Programmer_3" },

	{ 32, THING_ACOLYTE2RED,    "Order Sergeant", "Acolyte" },
	{ 32, THING_BEGGAR1,        "Prisoner", "Beggar" },

	{ 33, THING_ACOLYTE5DGREEN, "Acolyte", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{ 33, THING_ACOLYTE6GOLD,   "Body guard", "Strife_minor_characters_-_Hub_1#Acolytes" },
	{ 33, THING_MEDIC,          "Medic", "Strife_minor_characters_-_Hub_1#Medic" },
	{ 33, THING_ARMORER,        "Armorer", "Strife_minor_characters_-_Hub_1#Armorer" },
	{ 33, THING_WEAPONSMITH,    "Weapon smith (Bowyer)", "Strife_minor_characters_-_Hub_1#Bowyer" },
	{ 33, THING_BARKEEP,        "Barkeep", "Strife_minor_characters_-_Hub_1#Barkeep" },
	{ 33, THING_PEASANTBLUE,    "Governor Mourel", "" },
	{ 33, THING_PEASANTRED1,    "Harris", "" },
	{ 33, THING_PEASANTRED2,    "Harris", "" },
	{ 33, THING_PEASANTTAN3,    "Ulaine", "Strife_minor_characters_-_Hub_1#Ulaine" },

	{ 34, THING_REBEL2,         "Rebel (type 44)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{ 34, THING_REBEL3,         "Rebel (type 45)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{ 34, THING_REBEL4,         "Rebel (type 46)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{ 34, THING_REBEL5,         "Rebel (type 47)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{ 34, THING_REBEL6,         "Rebel (type 48)", "Strife_minor_characters_-_Hub_1#Rebels" },
	{ 34, THING_MEDIC,          "Medic (Gerard)", "Strife_minor_characters_-_Hub_1#Gerard" },
	{ 34, THING_WEAPONSMITH,    "Weapon smith (Feris)", "Strife_minor_characters_-_Hub_1#Feris" },
	{ 34, THING_PEASANTGRAY1,   "Advisor (type 12)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{ 34, THING_PEASANTGRAY2,   "Macil's advisor (type 13)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{ 34, THING_PEASANTGRAY3,   "Advisor (type 14)", "Strife_minor_characters_-_Hub_1#Advisors" },
	{ 34, THING_PEASANTRUST1,   "Peasant (type 15)", "Strife_minor_characters_-_Hub_1#Peasants_2" },
	{ 34, THING_PEASANTRUST2,   "Peasant (type 16)", "Strife_minor_characters_-_Hub_1#Peasants_2" },
};


/*
	initialize Doom thing classes and items
*/
void InitDoomThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Doom games", NULL);
	AppendClass( ThClassItem, "Items", "Item#Doom games", NULL);
	AppendClass( ThClassKeys, "Keys", "Key", NULL);
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_HUMAN, "Zombieman", ""); // 20
	AppendItem( ThClassMnst, THING_ST_HUMAN, "Stealth human", "Stealth monsters"); // 20
	AppendItem( ThClassMnst, THING_SERGEANT, "Shotgun guy", ""); // 30
	AppendItem( ThClassMnst, THING_ST_SERGEANT, "Stealth sergeant", "Stealth monsters"); // 30
	AppendItem( ThClassMnst, THING_COMMANDO, "Heavy weapon dude", ""); // 70
	AppendItem( ThClassMnst, THING_ST_COMMANDO, "Stealth commando", "Stealth monsters"); // 70
	AppendItem( ThClassMnst, THING_IMP, "Imp", ""); // 60
	AppendItem( ThClassMnst, THING_ST_IMP, "Stealth imp", "Stealth monsters"); // 60
	AppendItem( ThClassMnst, THING_LOSTSOUL, "Lost soul", ""); // 100
	AppendItem( ThClassMnst, THING_DEMON, "Demon", ""); // 150
	AppendItem( ThClassMnst, THING_ST_DEMON, "Stealth demon", "Stealth monsters"); // 150
	AppendItem( ThClassMnst, THING_SPECTRE, "Spectre", ""); // 150
	AppendItem( ThClassMnst, THING_REVENANT, "Revenant", ""); // 300
	AppendItem( ThClassMnst, THING_ST_REVENANT, "Stealth revenant", "Stealth monsters"); // 300
	AppendItem( ThClassMnst, THING_CACODEMON, "Cacodemon", ""); // 400
	AppendItem( ThClassMnst, THING_ST_CACODEMON, "Stealth cacodemon", "Stealth monsters"); // 400
	AppendItem( ThClassMnst, THING_PAINELEM, "Pain elemental", ""); // 400
	AppendItem( ThClassMnst, THING_KNIGHT, "Hell knight", ""); // 500
	AppendItem( ThClassMnst, THING_ST_KNIGHT, "Stealth knight", "Stealth monsters"); // 500
	AppendItem( ThClassMnst, THING_BARON, "Baron of Hell", ""); // 1000
	AppendItem( ThClassMnst, THING_ST_BARON, "Stealth baron", "Stealth monsters"); // 1000
	AppendItem( ThClassMnst, THING_ARACHNO, "Arachnotron", ""); // 500
	AppendItem( ThClassMnst, THING_ST_ARACHNO, "Stealth arachnotron", "Stealth monsters"); // 500
	AppendItem( ThClassMnst, THING_MANCUBUS, "Mancubus", ""); // 600
	AppendItem( ThClassMnst, THING_ST_MANCUBUS, "Stealth mancubus", "Stealth monsters"); // 600
	AppendItem( ThClassMnst, THING_ARCHVILE, "Arch-vile", ""); // 700
	AppendItem( ThClassMnst, THING_ST_ARCHVILE, "Stealth arch-vile", "Stealth monsters"); // 700
	AppendItem( ThClassMnst, THING_SPIDERBOSS, "Spiderdemon", ""); // 3000
	AppendItem( ThClassMnst, THING_CYBERDEMON, "Cyberdemon", ""); // 4000
	AppendItem( ThClassMnst, THING_WOLF3DSS, "Wolfenstein SS", ""); // 50
	AppendItem( ThClassMnst, THING_KEEN, "Commander Keen", ""); // 100
	AppendItem( ThClassMnst, THING_BOSSBRAIN, "Romero's head", ""); // 250
	AppendItem( ThClassMnst, THING_BOSSSHOOT, "Monster spawner", "");
	AppendItem( ThClassMnst, THING_SPAWNSPOT, "Spawn spot", "");
	AppendItem( ThClassMnst, THING_HELPERDOG, "Helper dog", ""); // 500

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CHAINSAW, "Chainsaw", "");
	AppendItem( ThClassWeap, THING_SHOTGUN, "Shotgun", "");
	AppendItem( ThClassWeap, THING_COMBATGUN, "Super shotgun", "");
	AppendItem( ThClassWeap, THING_CHAINGUN, "Chaingun", "");
	AppendItem( ThClassWeap, THING_LAUNCHER, "Rocket launcher", "");
	AppendItem( ThClassWeap, THING_PLASMAGUN, "Plasma gun", "");
	AppendItem( ThClassWeap, THING_BFG9000, "BFG9000", "");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_AMMOCLIP, "Clip", "");
	AppendItem( ThClassAmmo, THING_AMMOBOX, "Box of bullets", "");
	AppendItem( ThClassAmmo, THING_SHELLS, "4 shotgun shells", "");
	AppendItem( ThClassAmmo, THING_SHELLBOX, "Box of shotgun shells", "");
	AppendItem( ThClassAmmo, THING_ROCKET, "Rocket", "");
	AppendItem( ThClassAmmo, THING_ROCKETBOX, "Box of rockets", "");
	AppendItem( ThClassAmmo, THING_ENERGYCELL, "Energy cell", "Energy cell (Doom)");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy cell pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_STIMPACK, "Stimpack", "");
	AppendItem( ThClassHlAr, THING_MEDIKIT, "Medikit", "");
	AppendItem( ThClassHlAr, THING_GREENARMOR, "Armor", "");
	AppendItem( ThClassHlAr, THING_BLUEARMOR, "Megaarmor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_ARMBONUS1, "Armor bonus", "");
	AppendItem( ThClassItem, THING_HLTBONUS1, "Health bonus", "");
	AppendItem( ThClassItem, THING_SOULSPHERE, "Supercharge", "");
	AppendItem( ThClassItem, THING_MEGASPHERE, "Megasphere", "");
	AppendItem( ThClassItem, THING_BACKPACK, "Backpack", "");
	AppendItem( ThClassItem, THING_BERSERK, "Berserk", "");
	AppendItem( ThClassItem, THING_COMPMAP, "Computer area map", "");
	AppendItem( ThClassItem, THING_INVULN, "Invulnerability", "");
	AppendItem( ThClassItem, THING_LITEAMP, "Light amplification visor", "");
	AppendItem( ThClassItem, THING_BLURSPHERE, "Partial invisibility", "");
	AppendItem( ThClassItem, THING_RADSUIT, "Radiation shielding suit", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUECARD, "Blue keycard", NULL);
	AppendItem( ThClassKeys, THING_BLUESKULLKEY, "Blue skull key", NULL);
	AppendItem( ThClassKeys, THING_REDCARD, "Red keycard", NULL);
	AppendItem( ThClassKeys, THING_REDSKULLKEY, "Red skull key", NULL);
	AppendItem( ThClassKeys, THING_YELLOWCARD, "Yellow keycard", NULL);
	AppendItem( ThClassKeys, THING_YELLOWSKULLKEY, "Yellow skull key", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5D, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6D, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7D, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8D, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_BARREL, "Exploding barrel", "Barrel");
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGREEN, "Team Green start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGOLD, "Team Gold start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_VOODOODOLLS, "Voodoo doll", "");
}

/*
	initialize Heretic thing classes and items
*/
void InitHereticThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Heretic", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Heretic", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Heretic", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Heretic", NULL);
	AppendClass( ThClassItem, "Items", "Item#Heretic", NULL);
	AppendClass( ThClassKeys, "Keys", "Heretic keys", NULL);
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);
	AppendClass( ThClassSnds, "Ambient sounds", "Heretic ambient sound things", NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_GARGOYLE, "Gargoyle", ""); // 50
	AppendItem( ThClassMnst, THING_FRGARGOYLE, "Fire gargoyle", "Gargoyle"); // 80
	AppendItem( ThClassMnst, THING_GOLEM, "Golem", ""); // 80
	AppendItem( ThClassMnst, THING_GOLEMGH, "Golem ghost", "Golem"); // 80
	AppendItem( ThClassMnst, THING_NTGOLEM, "Nitrogolem", "Golem"); // 100
	AppendItem( ThClassMnst, THING_NTGOLEMGH, "Nitrogolem ghost", "Golem"); // 100
	AppendItem( ThClassMnst, THING_SABRECLAW, "Sabreclaw", ""); // 150
	AppendItem( ThClassMnst, THING_DISCIPLE, "Disciple", "Disciple of D'Sparil"); // 180
	AppendItem( ThClassMnst, THING_WARRIOR, "Undead Warrior", "Undead warrior"); // 200
	AppendItem( ThClassMnst, THING_WARRIORGH, "Undead Warrior ghost", "Undead warrior"); // 200
	AppendItem( ThClassMnst, THING_WEREDRAGON, "Weredragon", ""); // 220
	AppendItem( ThClassMnst, THING_OPHIDIAN, "Ophidian", ""); // 280
	AppendItem( ThClassMnst, THING_IRONLICH, "Iron lich", ""); // 700
	AppendItem( ThClassMnst, THING_MAULOTAUR, "Maulotaur", ""); // 3000
	AppendItem( ThClassMnst, THING_DSPARIL, "D'Sparil", ""); // 5500

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_GAUNTLETS, "Gauntlets of the Necromancer", "");
	AppendItem( ThClassWeap, THING_CROSSBOW, "Ethereal Crossbow", "");
	AppendItem( ThClassWeap, THING_DRAGONCLAW, "Dragon Claw", "");
	AppendItem( ThClassWeap, THING_HELLSTAFF, "Hellstaff", "");
	AppendItem( ThClassWeap, THING_PHOENIXROD, "Phoenix Rod", "");
	AppendItem( ThClassWeap, THING_FIREMACE, "Firemace", "");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_CRYSTAL, "Wand Crystal", "");
	AppendItem( ThClassAmmo, THING_CRGEODE, "Crystal Geode", "");
	AppendItem( ThClassAmmo, THING_ARROWS, "Ethereal Arrows", "");
	AppendItem( ThClassAmmo, THING_ARQUIVER, "Quiver of Ethereal Arrows", "");
	AppendItem( ThClassAmmo, THING_CLAWORB, "Claw Orb", "");
	AppendItem( ThClassAmmo, THING_ENERGYORB, "Energy Orb", "");
	AppendItem( ThClassAmmo, THING_RUNESSML, "Lesser Runes", "");
	AppendItem( ThClassAmmo, THING_RUNESLRG, "Greater Runes", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBSML, "Flame Orb", "");
	AppendItem( ThClassAmmo, THING_FLAMEORBLRG, "Inferno Orb", "");
	AppendItem( ThClassAmmo, THING_MACESPHSML, "Mace Spheres", "");
	AppendItem( ThClassAmmo, THING_MACESPHLRG, "Pile of Mace Spheres", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal Vial", "Crystal vial");
	AppendItem( ThClassHlAr, THING_ENCHSHIELD, "Enchanted Shield", "");
	AppendItem( ThClassHlAr, THING_SILVSHIELD, "Silver Shield", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BAGHOLDING, "Bag of Holding", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_MAPSCROLL, "Map Scroll", "Map scroll");
	AppendItem( ThClassItem, THING_MORPHOVUM, "Morph Ovum", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic Urn", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz Flask", "");
	AppendItem( ThClassItem, THING_RINGINVULN, "Ring of Invincibility", "");
	AppendItem( ThClassItem, THING_SHADOWSPHR, "Shadowsphere", "");
	AppendItem( ThClassItem, THING_TIMEBOMB, "Timebomb of the Ancients", "");
	AppendItem( ThClassItem, THING_TOMEPOWER, "Tome of Power", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_BLUEKEY, "Blue key", NULL);
	AppendItem( ThClassKeys, THING_GREENKEY, "Green key", NULL);
	AppendItem( ThClassKeys, THING_YELLOWKEY, "Yellow key", NULL);

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5H, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6H, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7H, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8H, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_DSPARILSPOT, "D'Sparil teleport spot", "D'Sparil");
	AppendItem( ThClassMisc, THING_KEYGIZMOBLUE, "Key gizmo (blue)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOGREEN, "Key gizmo (green)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_KEYGIZMOYELLOW, "Key gizmo (yellow)", "Heretic keys#Key gizmos");
	AppendItem( ThClassMisc, THING_POD, "Pod", "");
	AppendItem( ThClassMisc, THING_PODGENERATOR, "Pod generator", "Pod");
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGREEN, "Team Green start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_TEAMGOLD, "Team Gold start", "Capture the Flag");
	AppendItem( ThClassMisc, THING_GLITTELEEXIT, "Teleport glitter (blue)", NULL);
	AppendItem( ThClassMisc, THING_GLITTELEPORT, "Teleport glitter (red)", NULL);
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_VOODOODOLLS, "Voodoo doll", "");

	/* initialize ambient sounds */
	AppendItem( ThClassSnds, THING_SNDBELSS, "Bells", NULL);
	AppendItem( ThClassSnds, THING_SNDDROPS, "Drops", NULL);
	AppendItem( ThClassSnds, THING_SNDFASTFOOT, "Fast footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDGROWL, "Growl", NULL);
	AppendItem( ThClassSnds, THING_SNDHEARTBEAT, "Heart beat", NULL);
	AppendItem( ThClassSnds, THING_SNDLAUGHTER, "Laughter", NULL);
	AppendItem( ThClassSnds, THING_SNDMAGIC, "Magic", NULL);
	AppendItem( ThClassSnds, THING_SNDSCREAM, "Scream", NULL);
	AppendItem( ThClassSnds, THING_SNDSLOWFOOT, "Slow footsteps", NULL);
	AppendItem( ThClassSnds, THING_SNDSQUISH, "Squish", NULL);
	AppendItem( ThClassSnds, THING_SNDWATERFALL, "Waterfall", NULL);
	AppendItem( ThClassSnds, THING_SNDWIND, "Wind", NULL);
}

/*
	initialize Hexen thing classes and items
*/
void InitHexenThings( void)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Monsters", "Monster#Hexen", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Hexen", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Hexen", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Hexen", NULL);
	AppendClass( ThClassItem, "Items", "Item#Hexen", NULL);
	AppendClass( ThClassKeys, "Keys & Puzzle items", "Hexen keys",
	                          "[[Hexen keys|Keys]] & [[Item#Puzzle items|Puzzle items]]");
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);

	/* initialize monsters w/ hitpoints */
	AppendItem( ThClassMnst, THING_AFRIT, "Afrit", ""); // 80
	AppendItem( ThClassMnst, THING_STALKER, "Stalker", ""); // 90
	AppendItem( ThClassMnst, THING_STALKERBOSS, "Stalker boss", "Stalker"); // 90
	AppendItem( ThClassMnst, THING_WENDIGO, "Wendigo", ""); // 120
	AppendItem( ThClassMnst, THING_DARKBISHOP, "Dark bishop", ""); // 130
	AppendItem( ThClassMnst, THING_REIVER, "Reiver", ""); // 150
	AppendItem( ThClassMnst, THING_REIVERBURIED, "Reiver (Buried)", "Reiver"); // 150
	AppendItem( ThClassMnst, THING_ETTIN, "Ettin", ""); // 175
	AppendItem( ThClassMnst, THING_CENTAUR, "Centaur", ""); // 200
	AppendItem( ThClassMnst, THING_BROWNCSERP, "Brown chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_GREENCSERP, "Green chaos serpent", ""); // 250
	AppendItem( ThClassMnst, THING_SLAUGHTAUR, "Slaughtaur", ""); // 250
	AppendItem( ThClassMnst, THING_DEATHWYVERN, "Death wyvern", ""); // 640
	AppendItem( ThClassMnst, THING_MENELKIR, "Menelkir", ""); // 800
	AppendItem( ThClassMnst, THING_TRADUCTUS, "Traductus", ""); // 800
	AppendItem( ThClassMnst, THING_ZEDEK, "Zedek", ""); // 800
	AppendItem( ThClassMnst, THING_HERESIARCH, "Heresiarch", ""); // 5000
	AppendItem( ThClassMnst, THING_KORAX, "Korax", ""); // 5000

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_TIMONSAXE, "Timon's Axe", "");
	AppendItem( ThClassWeap, THING_HAMMERRETR, "Hammer of Retribution", "");
	AppendItem( ThClassWeap, THING_QUIETUSHILT, "Quietus (Hilt)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSCROSS, "Quietus (Cross)", "Quietus");
	AppendItem( ThClassWeap, THING_QUIETUSBLADE, "Quietus (Blade)", "Quietus");
	AppendItem( ThClassWeap, THING_SERPENTSTAFF, "Serpent Staff", "");
	AppendItem( ThClassWeap, THING_FIRESTORM, "Firestorm", "");
	AppendItem( ThClassWeap, THING_WVERGESHAFT, "Wraithverge (Shaft)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGECROSS, "Wraithverge (Cross)", "Wraithverge");
	AppendItem( ThClassWeap, THING_WVERGEARC, "Wraithverge (Arc)", "Wraithverge");
	AppendItem( ThClassWeap, THING_FROSTSHARDS, "Frost Shards", "");
	AppendItem( ThClassWeap, THING_ARCDEATH, "Arc of Death", "Arc of death");
	AppendItem( ThClassWeap, THING_BSCOURGESTICK, "Bloodscourge (Stick)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESTUB, "Bloodscourge (Stub)", "Bloodscourge");
	AppendItem( ThClassWeap, THING_BSCOURGESKULL, "Bloodscourge (Skull)", "Bloodscourge");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_BLUEMANA, "Blue mana", "");
	AppendItem( ThClassAmmo, THING_GREENMANA, "Green mana", "");
	AppendItem( ThClassAmmo, THING_COMBMANA, "Combined mana", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_CRYSTALVIAL, "Crystal Vial", "Crystal vial");
	AppendItem( ThClassHlAr, THING_AMULETWARD, "Amulet of Warding", "");
	AppendItem( ThClassHlAr, THING_FALCONSHIELD, "Falcon Shield", "");
	AppendItem( ThClassHlAr, THING_MESHARMOR, "Mesh Armor", "");
	AppendItem( ThClassHlAr, THING_PLATINUMHELM, "Platinum Helm", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_BANISHDEV, "Banishment Device", "");
	AppendItem( ThClassItem, THING_BOOTSSPEED, "Boots of Speed", "");
	AppendItem( ThClassItem, THING_CHAOSDEV, "Chaos Device", "");
	AppendItem( ThClassItem, THING_DARKSERVANT, "Dark Servant", "");
	AppendItem( ThClassItem, THING_DISCREPULS, "Disc of Repulsion", "");
	AppendItem( ThClassItem, THING_DSKINBRACERS, "Dragonskin Bracers", "");
	AppendItem( ThClassItem, THING_FLECHETTE, "Fléchette", "");
	AppendItem( ThClassItem, THING_ICONDEFEND, "Icon of the Defender", "");
	AppendItem( ThClassItem, THING_KRATERMIGHT, "Krater of Might", "");
	AppendItem( ThClassItem, THING_MYSTAMBINC, "Mystic Ambit Incant", "");
	AppendItem( ThClassItem, THING_MYSTICURN, "Mystic Urn", "");
	AppendItem( ThClassItem, THING_PORKALATOR, "Porkalator", "");
	AppendItem( ThClassItem, THING_QUARTZFLASK, "Quartz Flask", "");
	AppendItem( ThClassItem, THING_TORCH, "Torch", "");
	AppendItem( ThClassItem, THING_WINGS, "Wings of Wrath", "");

	/* initialize keys */
	AppendItem( ThClassKeys, THING_AXEKEY, "Axe Key", NULL);
	AppendItem( ThClassKeys, THING_CASTLEKEY, "Castle Key", NULL);
	AppendItem( ThClassKeys, THING_CAVEKEY, "Cave Key", NULL);
	AppendItem( ThClassKeys, THING_DUNGEONKEY, "Dungeon Key", NULL);
	AppendItem( ThClassKeys, THING_EMERALDKEY, "Emerald Key", NULL);
	AppendItem( ThClassKeys, THING_FIREKEY, "Fire Key", NULL);
	AppendItem( ThClassKeys, THING_HORNKEY, "Horn Key", NULL);
	AppendItem( ThClassKeys, THING_RUSTYKEY, "Rusty Key", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY, "Silver Key", NULL);
	AppendItem( ThClassKeys, THING_STEELKEY, "Steel Key", NULL);
	AppendItem( ThClassKeys, THING_SWAMPKEY, "Swamp Key", NULL);

	/* initialize puzzle items */
	AppendItem( ThClassKeys, THING_FLAMEMASK, "Flame Mask", "Puzzle item#The Mask");
	AppendItem( ThClassKeys, THING_HEARTDSPARIL, "Heart of D'Sparil", "Puzzle item#The Heart");
	AppendItem( ThClassKeys, THING_EMERALDPLANET1, "Emerald Planet 1", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_EMERALDPLANET2, "Emerald Planet 2", "Puzzle item#Hub 3: Heresiarch's Seminary");
	AppendItem( ThClassKeys, THING_RUBYPLANET, "Ruby Planet", NULL);
	AppendItem( ThClassKeys, THING_SAPPHPLANET1, "Sapphire Planet 1", NULL);
	AppendItem( ThClassKeys, THING_SAPPHPLANET2, "Sapphire Planet 2", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGBRNZSTL, "Clock Gear (Bronze in Steel)", "Puzzle item#The Clock");
	AppendItem( ThClassKeys, THING_CLOCKGBRONZE, "Clock Gear (Bronze)", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGSTLBRNZ, "Clock Gear (Steel in Bronze)", NULL);
	AppendItem( ThClassKeys, THING_CLOCKGSTEEL, "Clock Gear (Steel)", NULL);
	AppendItem( ThClassKeys, THING_DAEMONCODEX, "Daemon Codex", "Puzzle item#The Books");
	AppendItem( ThClassKeys, THING_LIBEROSCURA, "Liber Oscura", NULL);
	AppendItem( ThClassKeys, THING_YORICKSSKULL, "Yorick's Skull", "Puzzle item#Yorick's Statue");
	AppendItem( ThClassKeys, THING_GLAIVESEAL, "Glaive Seal", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_HOLYRELIC, "Holy Relic", "Puzzle item#Hub 5: Necropolis");
	AppendItem( ThClassKeys, THING_SIGILMAGUS, "Sigil of the Magus", "Puzzle item#Hub 5: Necropolis");

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5X, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6X, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7X, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8X, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_DESTRUCTREE, "Destructible tree", NULL);
	AppendItem( ThClassMisc, THING_MUSHROOM, "Mushroom", "");
	AppendItem( ThClassMisc, THING_SPIKE_DN, "Spike Down", "Spike");
	AppendItem( ThClassMisc, THING_SPIKE_UP, "Spike Up", "Spike");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	//AppendItem( ThClassMisc, THING_VOODOODOLLS, "Voodoo doll", "");
}

/*
	initialize Strife thing classes and items
*/
void InitStrifeThings( BCINT mission)
{
	/* initialize class headers */
	AppendClass( ThClassMnst, "Enemies", "Monster#Strife", NULL);
	AppendClass( ThClassChar, "Other characters", ":Category:Strife_characters", NULL);
	AppendClass( ThClassWeap, "Weapons", "Weapon#Strife", NULL);
	AppendClass( ThClassAmmo, "Ammunition", "Ammo#Strife", NULL);
	AppendClass( ThClassHlAr, "Health & Armor", "Item#Strife", NULL);
	AppendClass( ThClassItem, "Items", "Item#Strife", NULL);
	AppendClass( ThClassKeys, "Keys & Quest items", "Strife keys",
	                          "[[Strife keys|Keys]] & [[Item#Quest Items|Quest items]]");
	AppendClass( ThClassMisc, "Miscellaneous", NULL, NULL);

	/* initialize enemies w/ hitpoints */
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE8BLUE, "Acolyte (blue)", "Acolyte"); // 60
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE5DGREEN, "Acolyte (dark green)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE6GOLD, "Acolyte (gold)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE4GRAY, "Acolyte (gray)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE7LGREEN, "Acolyte (light green)", "Acolyte"); // 60
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE2RED, "Acolyte (red)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE3RUST, "Acolyte (rust)", "Acolyte"); // 70
	AppendStrife( mission,
	            ThClassMnst, THING_ACOLYTE1TAN, "Acolyte (tan)", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_SHADOWACOLYTE, "Shadow Acolyte", "Acolyte"); // 70
	AppendItem( ThClassMnst, THING_BECOMACOLYTE, "Becoming Acolyte", NULL); // 70
	AppendItem( ThClassMnst, THING_STALKER2, "Stalker", "Stalker (Strife)"); // 80
	AppendItem( ThClassMnst, THING_SENTINEL, "Sentinel", ""); // 100
	AppendItem( ThClassMnst, THING_CEILTURRET, "Ceiling turret", ""); // 125
	AppendItem( ThClassMnst, THING_REAVER, "Reaver", ""); // 150
	AppendItem( ThClassMnst, THING_TEMPLAR, "Templar", ""); // 300
	AppendItem( ThClassMnst, THING_CRUSADER, "Crusader", ""); // 400
	AppendItem( ThClassMnst, THING_BISHOP, "Bishop", ""); // 500
	AppendItem( ThClassMnst, THING_ORACLE, "Oracle", ""); // 1
	AppendItem( ThClassMnst, THING_MACIL1, "Macil", ""); // 95
	AppendItem( ThClassMnst, THING_MACIL2SP, "Macil Spectre", "Macil"); // 95
	AppendItem( ThClassMnst, THING_LOREMASTER, "Loremaster", ""); // 800
	AppendItem( ThClassMnst, THING_INQUISITOR, "Inquisitor", ""); // 1000
	AppendItem( ThClassMnst, THING_PROGRAMMER, "Programmer", ""); // 1100
	AppendItem( ThClassMnst, THING_SPECTREPROGR, "Spectre (Programmer)", "Spectre (Strife)"); // 1000
	AppendItem( ThClassMnst, THING_SPECTREBISHOP, "Spectre (Bishop)", "Spectre (Strife)"); // 1200
	AppendItem( ThClassMnst, THING_SPECTREORACLE, "Spectre (Oracle)", "Spectre (Strife)"); // 1500
	AppendItem( ThClassMnst, THING_SPECTREMACIL, "Spectre (Macil)", "Spectre (Strife)"); // 1700
	AppendItem( ThClassMnst, THING_SPECTRELOREM, "Spectre (Loremaster)", "Spectre (Strife)"); // 2000
	AppendItem( ThClassMnst, THING_ENTITY, "Entity", ""); // 2500
	AppendItem( ThClassMnst, THING_ENTITYNEST, "Entity nest", "Entity"); // 1000
	AppendItem( ThClassMnst, THING_ENTITYPOD, "Entity pod", "Entity"); // 1000

	/* initialize other characters */
	AppendStrife( mission,
	            ThClassChar, THING_ARMORER, "Armorer", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_BARKEEP, "Barkeep", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_MEDIC, "Medic", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_WEAPONSMITH, "Weapon smith", "Merchant");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL1, "Rebel 1", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL2, "Rebel 2", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL3, "Rebel 3", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL4, "Rebel 4", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL5, "Rebel 5", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_REBEL6, "Rebel 6", "Rebel");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR1, "Beggar 1", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR2, "Beggar 2", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR3, "Beggar 3", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR4, "Beggar 4", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_BEGGAR5, "Beggar 5", "Beggar");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTBLUE, "Peasant Blue", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN1, "Peasant Dark Green 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN2, "Peasant Dark Green 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTDGRN3, "Peasant Dark Green 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD1, "Peasant Gold 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD2, "Peasant Gold 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGOLD3, "Peasant Gold 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY1, "Peasant Gray 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY2, "Peasant Gray 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTGRAY3, "Peasant Gray 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN1, "Peasant Light Green 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN2, "Peasant Light Green 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTLGRN3, "Peasant Light Green 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED1, "Peasant Red 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED2, "Peasant Red 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRED3, "Peasant Red 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST1, "Peasant Rust 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST2, "Peasant Rust 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTRUST3, "Peasant Rust 3", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN1, "Peasant Tan 1", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN2, "Peasant Tan 2", "Peasant");
	AppendStrife( mission,
	            ThClassChar, THING_PEASANTTAN3, "Peasant Tan 3", "Peasant");
	AppendItem( ThClassChar, THING_KNEELGUY, "Kneeling Guy", "");
	AppendItem( ThClassChar, THING_ZOMBIE, "Zombie", "Peasant#Related_actors");
	AppendItem( ThClassChar, THING_ZOMBIESPAWN, "Zombie spawner", NULL);

	/* initialize weapons */
	AppendItem( ThClassWeap, THING_CROSSBOW2, "Crossbow", "");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE, "Assault rifle (lying)", "Assault rifle");
	AppendItem( ThClassWeap, THING_ASSAULTRIFLE2, "Assault rifle (standing)", "Assault rifle");
	AppendItem( ThClassWeap, THING_MINIMSLAUNCH, "Mini-missile launcher", "");
	AppendItem( ThClassWeap, THING_GRENADELAUNCH, "Grenade launcher", "");
	AppendItem( ThClassWeap, THING_FLAMETHROW, "Flamethrower", "");
	AppendItem( ThClassWeap, THING_MAULER, "Mauler", "");
	AppendItem( ThClassWeap, THING_SIGIL1, "Sigil 1 (Lightning)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL2, "Sigil 2 (Rail)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL3, "Sigil 3 (Spread)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL4, "Sigil 4 (Column)", "The Sigil of the One God");
	AppendItem( ThClassWeap, THING_SIGIL5, "Sigil 5 (Blast)", "The Sigil of the One God");

	/* initialize ammo */
	AppendItem( ThClassAmmo, THING_ELECBOLTS, "Electric bolt", "");
	AppendItem( ThClassAmmo, THING_POISBOLTS, "Poison bolt", "");
	AppendItem( ThClassAmmo, THING_BULLETCLIP, "Bullet clip", "");
	AppendItem( ThClassAmmo, THING_BULLETSBOX, "Box of bullets", "Box of bullets (Strife)");
	AppendItem( ThClassAmmo, THING_MISSILES, "Mini-missile", "");
	AppendItem( ThClassAmmo, THING_MISSILECRATE, "Crate of missiles", "");
	AppendItem( ThClassAmmo, THING_GASGRENADE, "Gas grenade", ""); // unused
	AppendItem( ThClassAmmo, THING_HEGRENADE, "HE grenade", "");
	AppendItem( ThClassAmmo, THING_PHOSPHGRENADE, "Phosphorous grenade", "");
	AppendItem( ThClassAmmo, THING_ENERGYPOD, "Energy pod", "");
	AppendItem( ThClassAmmo, THING_ENERGYPACK, "Energy pack", "");

	/* initialize health/armor */
	AppendItem( ThClassHlAr, THING_MEDPATCH, "Med patch", "");
	AppendItem( ThClassHlAr, THING_MEDICALKIT, "Medical kit", "");
	AppendItem( ThClassHlAr, THING_SURGERYKIT, "Surgery kit", "");
	AppendItem( ThClassHlAr, THING_LEATHERARMOR, "Leather armor", "");
	AppendItem( ThClassHlAr, THING_METALARMOR, "Metal armor", "");

	/* initialize powerups/items */
	AppendItem( ThClassItem, THING_AMMOSATCHEL, "Ammo satchel", "");
	AppendItem( ThClassItem, THING_COMMUNICATOR, "Communicator", "");
	AppendItem( ThClassItem, THING_ENVIRONSUIT, "Environmental suit", "");
	AppendItem( ThClassItem, THING_GOLDCOIN, "Gold coin", "Gold");
	AppendItem( ThClassItem, THING_GOLD10, "10 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD25, "25 Gold", "Gold");
	AppendItem( ThClassItem, THING_GOLD50, "50 Gold", "Gold");
	AppendItem( ThClassItem, THING_MAPSTRIFE, "Map", "Map (Strife)");
	AppendItem( ThClassItem, THING_SCANNER, "Scanner", "");
	AppendItem( ThClassItem, THING_SHADOWARMOR, "Shadow armor", "");
	AppendItem( ThClassItem, THING_TARGETER, "Targeter", "");
	AppendItem( ThClassItem, THING_TELEPBEACON, "Teleporter beacon", "");
	AppendItem( ThClassItem, THING_REDTALIS, "Red talisman", "Talisman"); // VE
	AppendItem( ThClassItem, THING_GREENTALIS, "Green talisman", "Talisman"); // VE
	AppendItem( ThClassItem, THING_BLUETALIS, "Blue talisman", "Talisman"); // VE

	/* initialize keys */
	AppendItem( ThClassKeys, THING_IDBADGE, "ID Badge", NULL);
	AppendItem( ThClassKeys, THING_IDCARD, "ID Card", NULL);
	AppendItem( ThClassKeys, THING_BASEKEY, "Base Key", NULL);
	AppendItem( ThClassKeys, THING_BLUECRYSKEY, "Blue Crystal Key", NULL);
	AppendItem( ThClassKeys, THING_BRASSKEY, "Brass Key", NULL);
	AppendItem( ThClassKeys, THING_CHAPELKEY, "Chapel Key", NULL);
	AppendItem( ThClassKeys, THING_COREKEY, "Core Key", NULL);
	AppendItem( ThClassKeys, THING_FACTORYKEY, "Factory Key", NULL);
	AppendItem( ThClassKeys, THING_GOLDKEY, "Gold Key", NULL);
	AppendItem( ThClassKeys, THING_MAULERKEY, "Mauler Key", NULL);
	AppendItem( ThClassKeys, THING_MINEKEY, "Mine Key", NULL);
	AppendItem( ThClassKeys, THING_ORACLEKEY, "Oracle Key", NULL);
	AppendItem( ThClassKeys, THING_ORDERKEY, "Order Key", NULL);
	AppendItem( ThClassKeys, THING_PASSCARD, "Pass Card", NULL);
	AppendItem( ThClassKeys, THING_REDCRYSKEY, "Red Crystal Key", NULL);
	AppendItem( ThClassKeys, THING_SEVEREDHAND, "Severed Hand", NULL);
	AppendItem( ThClassKeys, THING_SILVERKEY2, "Silver Key", NULL);
	AppendItem( ThClassKeys, THING_WAREHOUSEKEY, "Warehouse Key", NULL);

	/* initialize quest items */
	AppendItem( ThClassKeys, THING_BRKNPWRCOUPL, "Broken power coupling", "Strife quest items#Broken power coupling");
	AppendItem( ThClassKeys, THING_POWERCOUPL, "Power coupling", NULL);
	AppendItem( ThClassKeys, THING_DEGNINORE, "Degnin ore", "Strife quest items#Degnin ore");
	AppendItem( ThClassKeys, THING_ORESPAWNER, "Ore spawner", "Strife quest items#Degnin ore"); // VE
	AppendItem( ThClassKeys, THING_FFIELDGUARD, "Force field guard", NULL);
	AppendItem( ThClassKeys, THING_GATEPISTON, "Gate piston", "Strife technology#Gate control");
	AppendItem( ThClassKeys, THING_OFFICERUNIF, "Officer uniform", "Strife quest items#Officer uniform");
	AppendItem( ThClassKeys, THING_GUARDUNIF, "Guard uniform", "Strife quest items#Guard uniform");
	AppendItem( ThClassKeys, THING_POWERCRYSTAL, "Power crystal", "Strife technology#Power crystal");
	AppendItem( ThClassKeys, THING_OFFERCHALICE1, "Offering chalice", "");
	AppendItem( ThClassKeys, THING_OFFERCHALICE2, "Blue chalice", "Offering chalice#Veteran Edition"); // VE
	AppendItem( ThClassKeys, THING_COMPUTER, "Computer", "Strife technology#Computer");

	/* initialize miscellaneous */
	AppendItem( ThClassMisc, THING_PLAYER1, "Player 1 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER2, "Player 2 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER3, "Player 3 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER4, "Player 4 start", "Player");
	AppendItem( ThClassMisc, THING_PLAYER5S, "Player 5 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER6S, "Player 6 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER7S, "Player 7 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_PLAYER8S, "Player 8 start", "zdoom:Player start");
	AppendItem( ThClassMisc, THING_COOPSTARTS, "Cooperative start", "Multiplayer#Cooperative");
	AppendItem( ThClassMisc, THING_DEATHMATCH, "Deathmatch start", "");
	AppendItem( ThClassMisc, THING_BARRELSTRIFE, "Exploding barrel", "Barrel (Strife)");
	AppendItem( ThClassMisc, THING_TEAMBLUE, "Team Blue start", "Capture the Chalice");
	AppendItem( ThClassMisc, THING_TEAMRED, "Team Red start", "Capture the Chalice");
	AppendItem( ThClassMisc, THING_TELEPORT, "Teleport landing", "Teleporter");
	AppendItem( ThClassMisc, THING_VOODOODOLLS, "Voodoo doll", "");
	AppendItem( ThClassMisc, THING_WOODENBARREL, "Wooden barrel", "Barrel (Strife)");
}


/*
	analyze thing statistics
*/
void AnalyzeThings( BCINT lumpver, Bool noskill)
{
	int n, m, item;
	BCINT when;

	/* collect all level's things */
	for (n = 0; n < NumThings; n++)
	{
		/* find item for this thing */
		item = -1;
		for (m = 0; m < NumThItems; m++)
			if (Things[n].type == ThItems[m]->type)
			{
				item = m;
				break;
			}

		/* check whether this thing shows up */
		when = Things[n].when;
		if (noskill &&
		    (when & (TF_SEASY | TF_SMEDM | TF_SHARD)) == 0 &&
		    Things[n].type != THING_BUILDCAM)
		{
			/* use name for this thing if available */
			if (item == -1)
				printf( "Note: Thing %d (type %d%s) has no skill flags\n", n,
					      Things[n].type, (when & TF_NOTSP) != 0 ? ", MP" : "");
			else
				printf( "Note: Thing %d (%s, type %d%s) has no skill flags\n", n,
				        ThItems[item]->wikiname,
					      Things[n].type, (when & TF_NOTSP) != 0 ? ", MP" : "");
			continue;
		}

		/* not keeping stats on this thing */
		if (item == -1)
			continue;

		/* check thing flags */
		if ((lumpver & 0xF0) == 0x40) // Hexen format
		{
			// single-player
			if ((when & TF_HXNSP) != 0)
			{
				// all classes
				if ((when & TF_SEASY) != 0)
					ThItems[item]->easy[ThModeSP]++;
				if ((when & TF_SMEDM) != 0)
					ThItems[item]->medm[ThModeSP]++;
				if ((when & TF_SHARD) != 0)
					ThItems[item]->hard[ThModeSP]++;

				/* check whether this thing shows up for any class */
				if (noskill &&
				    (when & TF_HCLRC) == 0 && (when & TF_HFGHT) == 0 && (when & TF_HMAGE) == 0)
				{
					if (item == -1)
						printf( "Note: Thing %d (type %d) has no class flags\n", n,
						        Things[n].type);
					else
						printf( "Note: Thing %d (%s, type %d) has no class flags\n", n,
						        ThItems[item]->wikiname, Things[n].type);
				}

				// Cleric class
				if ((when & TF_HCLRC) != 0)
				{
					if ((when & TF_SEASY) != 0)
						ThItems[item]->easy[ThModeXC]++;
					if ((when & TF_SMEDM) != 0)
						ThItems[item]->medm[ThModeXC]++;
					if ((when & TF_SHARD) != 0)
						ThItems[item]->hard[ThModeXC]++;
				}
				// Fighter class
				if ((when & TF_HFGHT) != 0)
				{
					if ((when & TF_SEASY) != 0)
						ThItems[item]->easy[ThModeXF]++;
					if ((when & TF_SMEDM) != 0)
						ThItems[item]->medm[ThModeXF]++;
					if ((when & TF_SHARD) != 0)
						ThItems[item]->hard[ThModeXF]++;
				}
				// Mage class
				if ((when & TF_HMAGE) != 0)
				{
					if ((when & TF_SEASY) != 0)
						ThItems[item]->easy[ThModeXM]++;
					if ((when & TF_SMEDM) != 0)
						ThItems[item]->medm[ThModeXM]++;
					if ((when & TF_SHARD) != 0)
						ThItems[item]->hard[ThModeXM]++;
				}
			}

			// cooperative
			if ((when & TF_HXNCP) != 0)
			{
				if ((when & TF_SEASY) != 0)
					ThItems[item]->easy[ThModeCP]++;
				if ((when & TF_SMEDM) != 0)
					ThItems[item]->medm[ThModeCP]++;
				if ((when & TF_SHARD) != 0)
					ThItems[item]->hard[ThModeCP]++;
			}
			// deathmath
			if ((when & TF_HXNDM) != 0)
			{
				if ((when & TF_SEASY) != 0)
					ThItems[item]->easy[ThModeDM]++;
				if ((when & TF_SMEDM) != 0)
					ThItems[item]->medm[ThModeDM]++;
				if ((when & TF_SHARD) != 0)
					ThItems[item]->hard[ThModeDM]++;
			}
		}
		else // Doom format
		{
			// single-player
			if ((when & TF_NOTSP) == 0)
			{
				if ((when & TF_SEASY) != 0)
					ThItems[item]->easy[ThModeSP]++;
				if ((when & TF_SMEDM) != 0)
					ThItems[item]->medm[ThModeSP]++;
				if ((when & TF_SHARD) != 0)
					ThItems[item]->hard[ThModeSP]++;
			}
			// classic multi-player
				if ((when & TF_SEASY) != 0)
					ThItems[item]->easy[ThModeMP]++;
				if ((when & TF_SMEDM) != 0)
					ThItems[item]->medm[ThModeMP]++;
				if ((when & TF_SHARD) != 0)
					ThItems[item]->hard[ThModeMP]++;

			// Boom multiplayer
			if ((GameVersion & 0xF0) < 0x20)
			{
				// cooperative
				if ((when & TF_NCOOP) == 0)
				{
					if ((when & TF_SEASY) != 0)
						ThItems[item]->easy[ThModeCP]++;
					if ((when & TF_SMEDM) != 0)
						ThItems[item]->medm[ThModeCP]++;
					if ((when & TF_SHARD) != 0)
						ThItems[item]->hard[ThModeCP]++;
				}
				// deathmatch
				if ((Things[n].when & TF_NOTDM) == 0)
				{
					if ((when & TF_SEASY) != 0)
						ThItems[item]->easy[ThModeDM]++;
					if ((when & TF_SMEDM) != 0)
						ThItems[item]->medm[ThModeDM]++;
					if ((when & TF_SHARD) != 0)
						ThItems[item]->hard[ThModeDM]++;
				}
			}
		}
	}
	//DumpThings( (GameVersion & 0xF0) == 0x40 ? ThModeCP : ThModeSP);
}


/*
	forget the things data
*/
void ForgetThings( void)
{
	int n;

	for (n = 0; n < NumThClasses; n++)
		if (ThClasses[n] != NULL)
		{
			FreeMemory( ThClasses[n]->wikiname);
			if (ThClasses[n]->wikilink != NULL)
				FreeMemory( ThClasses[n]->wikilink);
			FreeMemory( ThClasses[n]->wikistr);
			FreeMemory( ThClasses[n]);
		}

	FreeMemory( ThClasses);
	ThClasses = NULL;
	NumThClasses = 0;

	for (n = 0; n < NumThItems; n++)
		if (ThItems[n] != NULL)
		{
			FreeMemory( ThItems[n]->wikiname);
			if (ThItems[n]->wikilink != NULL)
				FreeMemory( ThItems[n]->wikilink);
			FreeMemory( ThItems[n]->wikistr);
			FreeMemory( ThItems[n]);
		}

	FreeMemory( ThItems);
	ThItems = NULL;
	NumThItems = 0;

	FreeMemory( UsedLinks);
	UsedLinks = NULL;
	NumUsedLinks = 0;
}

/*
	dump the things data for the given mode
*/
void DumpThings( UBCINT mode)
{
	int c, i;

	for (c = 0; c < NumThClasses; c++)
	{
		printf( "%3d:         %28s %-58.58s\n", ThClasses[c]->class,
		        ThClasses[c]->wikiname, ThClasses[c]->wikistr);
		for (i = 0; i < NumThItems; i++)
			if (ThClasses[c]->class == ThItems[i]->class)
				printf( "%3d: %d %5d %28s %-66.66s %3d %3d %3d\n", i,
				        ThItems[i]->class, ThItems[i]->type, ThItems[i]->wikiname, ThItems[i]->wikistr,
				        ThItems[i]->easy[mode], ThItems[i]->medm[mode], ThItems[i]->hard[mode]);
	}
	printf( "\n");
}


/*
	check all things for Boom multiplayer flags
*/
Bool CheckThingBoomFlags( void)
{
	int n;

	/* check in Doom/Heretic for Boom flags */
	if ((GameVersion & 0xF0) < 0x20)
		for (n = 0; n < NumThings; n++)
			if ((Things[n].when & (TF_NOTDM | TF_NCOOP)) != 0)
				return TRUE;

	return FALSE;
}

/*
	use (linked) wiki string for the first wiki link, and then wiki name
*/
char *UsedWiki( char *wikiname, char *wikilink, char *wikistr)
{
	Bool found = FALSE;
	int i;

	/* if no link, always use plain name */
	if (wikilink == NULL)
		found = TRUE;
	else
		/* find possibly used wiki link or name */
		for (i = 0; i < NumUsedLinks; i++)
			if (strcmp( (strcmp( wikilink, "") != 0 ? wikilink : wikiname),
			            UsedLinks[i]) == 0)
			{
				found = TRUE;
				break;
			}

	/* if wiki string already used, return name */
	if (found)
		return wikiname;
	else
	{
		/* append wiki string to global array */
		UsedLinks = ResizeMemory( UsedLinks, (NumUsedLinks+1) * sizeof(char *));
		UsedLinks[NumUsedLinks++] = (strcmp( wikilink, "") != 0) ? wikilink : wikiname;
		return wikistr;
	}
}


/*
	create a thing class and append it to classes array
*/
void AppendClass( UBCINT class, char *wikiname, char *wikilink, char *wikistr)
{
	ThClass *tptr;
	int ret;

	/* initialize class */
	tptr = (ThClass *) GetMemory( sizeof(ThClass));
	tptr->class = class;
	tptr->wikiname = strdup( wikiname);
	if (wikilink != NULL)
	{
		tptr->wikilink = strdup( wikilink);
		/* special handling of class headers with multiple links */
		if (wikistr != NULL)
			tptr->wikistr = strdup( wikistr);
		else
		{
			ret = asprintf( &tptr->wikistr, "[[%s|%s]]", wikilink, wikiname);
			if (ret == -1)
				ProgError( "unable to concatenate class wiki string");
		}
	}
	else /* don't link */
	{
		tptr->wikilink = NULL;
		tptr->wikistr = strdup( wikiname);
	}

	/* append class to global array */
	ThClasses = ResizeMemory( ThClasses, (NumThClasses+1) * sizeof(tptr));
	ThClasses[NumThClasses++] = tptr;
}

/*
	create a Strife character item and append it to items array
	if in translation table, then use map-specific name and link, otherwise defaults
*/
void AppendStrife( BCINT mission, UBCINT class, UBCINT type, char *wikiname, char *wikilink)
{
	int i;
	Bool found = FALSE;

	/* translate character if no PWAD(s) loaded */
	if (PatchWads == NULL)
		for (i = 0; i < NUMCHARS; i++)
			if (mission == StrifeChars[i].mapnr && type == StrifeChars[i].thgid)
			{
				found = TRUE;
				break;
			}

	if (found)
	{
		AppendItem( class, type, StrifeChars[i].wikiname, StrifeChars[i].wikilink);
		SortStrife( class);
	}
	else
		AppendItem( class, type, wikiname, wikilink);
}

/*
	create a thing item and append it to items array
	wikilink: if non-empty string, use as link in [[link|name]]
	          if empty string, use wikiname as link in [[name]]
	          if NULL, don't link wikiname
*/
void AppendItem( UBCINT class, UBCINT type, char *wikiname, char *wikilink)
{
	ThItem *tptr;
	int m, ret;

	/* initialize item */
	tptr = (ThItem *) GetMemory( sizeof(ThItem));
	tptr->class = class;
	tptr->type = type;
	tptr->custom = FALSE;
	for (m = 0; m < ThMode_End; m++)
		tptr->easy[m] = tptr->medm[m] = tptr->hard[m] = 0;

	/* compile wiki string */
	tptr->wikiname = strdup( wikiname);
	if (wikilink != NULL)
	{
		tptr->wikilink = strdup( wikilink);
		if (strcmp( wikilink, "") != 0) /* use alternate link */
			ret = asprintf( &tptr->wikistr, "[[%s|%s]]", wikilink, wikiname);
		else /* use name as link */
			ret = asprintf( &tptr->wikistr, "[[%s]]", wikiname);
	}
	else /* don't link */
	{
		tptr->wikilink = NULL;
		tptr->wikistr = strdup( wikiname);
	}
	if (ret == -1)
		ProgError( "unable to concatenate item wiki string");

	/* append item to global array */
	ThItems = ResizeMemory( ThItems, (NumThItems+1) * sizeof(tptr));
	ThItems[NumThItems++] = tptr;
}

/*
	sort most recently appended, custom Strife item alphabetically within its class,
	leaving the default items in the same order after the custom ones
*/
void SortStrife( UBCINT class)
{
	BCINT i, j;
	ThItem *tptr;

	/* mark most recently appended item as custom */
	tptr = ThItems[NumThItems-1];
	tptr->custom = TRUE;
	/* no sorting of a one-item list */
	if (NumThItems == 1)
		return;

	/* search back within class for item after which to sort the most recent one */
	for (i = NumThItems-2; i >= 0; i--)
	{
		/* check if no longer same class */
		if (ThItems[i]->class != class)
			break;
		/* check if this custom item should stay before most recent one */
		if (ThItems[i]->custom && strcmp( ThItems[i]->wikiname, tptr->wikiname) <= 0)
			break;
	}

	/* move most recent item into new slot */
	for (j = NumThItems-1; j > i+1; j--)
		ThItems[j] = ThItems[j-1];
	ThItems[j] = tptr;
}


#define BUFSIZE 120

/*
	add/update custom things from mapping file
*/
void ReadCustomThings( void)
{
	FILE *mapfile;
	char buf[BUFSIZE], *field;
	BCINT i, j;
	ThItem *tptr;
	UBCINT class, type;
	char *wikiname, *wikilink;

	/* read custom thing translations */
	if ((mapfile = fopen( CustomMap, "r")) == NULL)
		ProgError( "error opening custom map \"%s\"", CustomMap);

	while (fgets( buf, BUFSIZE, mapfile) != NULL)
	{
		/* skip comment lines */
		if (buf[0] == '#')
			continue;

		/* read tab-spaced fields */
		if ((field = strtok( buf, "\t")) == NULL)
			ProgError( "error reading custom map \"%s\"", CustomMap);
		class = atoi( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom map \"%s\"", CustomMap);
		type = atoi( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom map \"%s\"", CustomMap);
		wikiname = strdup( field);

		if ((field = strtok( NULL, "\t")) == NULL)
			ProgError( "error reading custom map \"%s\"", CustomMap);
		if (field[strlen(field)-1] == '\n')
			field[strlen(field)-1] = '\0';
		if (field[0] == '\0')
			wikilink = NULL;
		else if (field[0] == '~')
			wikilink = strdup( "");
		else
			wikilink = strdup( field);

		/* find existing item */
		for (i = 0; i < NumThItems; i++)
			if (ThItems[i]->type == type)
			{
				/* discard existing item */
				FreeMemory( ThItems[i]->wikiname);
				if (ThItems[i]->wikilink != NULL)
					FreeMemory( ThItems[i]->wikilink);
				FreeMemory( ThItems[i]->wikistr);

				/* move up subsequent items */
				tptr = ThItems[i];
				for (j = i; j < NumThItems-1; j++)
					ThItems[j] = ThItems[j+1];
				FreeMemory( tptr);
				NumThItems--;
				break;
			}

		/* append custom item */
		AppendItem( class, type, wikiname, wikilink);
		FreeMemory( wikiname);
		FreeMemory( wikilink);
	}

	fclose( mapfile);
}

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
