/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	LEVELS.H - Level data definitions.
*/

#ifndef LEVELS_H
#define LEVELS_H

#include "wstructs.h"
#include "wads.h"


/*
	the global variables
*/
MDirPtr  Level;     /* master dictionary entry for the level */
char    *LevelName; /* official name for the level */

UBCINT NumThings;   /* number of things */
TPtr      Things;   /* things data */
UBCINT NumLineDefs; /* number of line defs */
LDPtr     LineDefs; /* line defs data */
UBCINT NumSideDefs; /* number of side defs */
SDPtr     SideDefs; /* side defs data */
BCLNG  TotVertexes; /* total number of vertexes */
BCLNG  NumVertexes; /* number of used vertexes */
VPtr      Vertexes; /* vertex data */
UBCINT NumSegs;     /* number of segments */
SEPtr     Segs,     /* list of segments */
			 LastSeg;     /* last segment in the list */
UBCINT NumSSectors; /* number of subsectors */
SSPtr     SSectors, /* list of subsectors */
			 LastSSector; /* last subsector in the list */
UBCINT NumSectors;  /* number of sectors */
SPtr      Sectors;  /* sectors data */

BCINT MapMaxX;      /* maximum X value of map */
BCINT MapMaxY;      /* maximum Y value of map */
BCINT MapMinX;      /* minimum X value of map */
BCINT MapMinY;      /* minimum Y value of map */

char *LevelNames1[4][9];
char *LevelNames2[32];
char *LevelNamesT[32];
char *LevelNamesP[32];
char *LevelNamesH[6][9];
char *LevelNamesX[40];
char *LevelNamesD[30];
char *LevelNamesS[38];


/*
	the global function prototypes
*/
void CheckLevelParams( BCINT, BCINT);
BCINT ReadLevelData( BCINT, BCINT);
void ForgetLevelData( void);

#endif /* LEVELS_H */

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
