/*
	DooM MaP StaTistics, by Frans P. de Vries.

Derived from:

	DooM PostScript Maps Utility, by Frans P. de Vries.

And thus from:

	Doom Editor Utility, by Brendon Wyber and Raphaël Quinet.

	You are allowed to use any parts of this code in another program, as
	long as you give credits to the authors in the documentation and in
	the program itself.  Read the file README for more information.

	This program comes with absolutely no warranty.

	DMMPST.H - Main DMMPST definitions.
*/

#include <stdio.h>
#include <stdint.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <ctype.h>
#include "dmunix.h"


/*
	the global definitions
*/
#define DMMPST_VERSION "1.9"
#define DEU_VERSION "5.21 GCC" /* DJGPP/GO32 version */

typedef int16_t  BCINT;
typedef uint16_t UBCINT;
typedef uint8_t  UBYTE;
typedef int32_t  BCLNG;


/*
	syntactic sugar
*/
typedef BCINT Bool; /* Boolean data: true or false */

/* boolean constants */
#ifndef TRUE
#define TRUE  1
#define FALSE 0
#endif


/*
	Description of the command line arguments and config file keywords.
*/
typedef struct
{
	char *short_name;   /* abbreviated command line argument */
	char *long_name;    /* command line arg. or keyword */
	enum {              /* type of this option: */
		OPT_BOOLEAN,      /* boolean (toggle) */
		OPT_INTEGER,      /* integer number */
		OPT_LONG,         /* long int number */
		OPT_STRING,       /* character string */
		OPT_STRINGACC,    /* character string, but store in a list */
		OPT_STRINGLIST,   /* list of character strings */
		OPT_END           /* end of the options description */
	}     opt_type;
	char *msg_if_true;  /* message printed if option is true */
	char *msg_if_false; /* message printed if option is false */
	void *data_ptr;     /* pointer to the data */
} OptDesc;


/*
	the global variables
*/
BCINT GameVersion; /* which game and version? */
char *MainWad;     /* name of the main WAD file */
char **PatchWads;  /* list of patch WAD files */
char *UserLvlNm;   /* user defined level name */
char *UserGamNm;   /* user defined game/megawad name */
char *CustomMap;   /* path to custom Things translations */
char *WkTpPath;    /* path to DoomWiki input templates */
FILE *WkFile;      /* the DoomWiki output file */
Bool Verbose;      /* verbose statistics? */
Bool WSkeleton;    /* skeleton wiki? */
Bool WSecrets;     /* secrets wiki? */
Bool WStatistics;  /* statistics wiki? */
Bool WMapdata;     /* map data wiki? */
Bool WThings;      /* things wiki? */
Bool WBoomMP;      /* Boom multiplayer in things wiki? */
Bool WXcludeSP;    /* exclude SP/Coop, only MP/DM things? */
BCLNG WSplitDM;    /* split DM table by classes */
BCLNG AppearType;  /* tally appearance by thing type */


/*
	the global function prototypes
*/
int main( int, char *[]);
void ProgError( char *, ...);

/* vim:set noexpandtab tabstop=2 softtabstop=2 shiftwidth=2: */
