#ifndef NODE_H
#define NODE_H

typedef struct{
	int type;		/* player, guest, status, god */
	int status;		/* unused, active, sleeping */
	int sd;			/* socket descriptor */
	char name[128];
	char email[128];
	char alias[16];
	char ip[4*4+10];
} Node;

enum { PLAYER, GUEST, STATUS, GOD, UNKNOWN };
enum { UNUSED, ACTIVE, SLEEP };

#define MAX_PLAYERS			4
#define MAX_GUESTS			5
#define MAX_GODS			2
#define MAX_NODES			(MAX_PLAYERS+MAX_GUESTS+MAX_GODS)

extern Node nodes[];
extern int nodeidx;

#define IsUnused(nd)		((nd).status == UNUSED)
#define IsActive(nd)		((nd).status == ACTIVE)
#define IsAsleep(nd)		((nd).status == SLEEP)
#define IsPlayer(nd)		((nd).type == PLAYER && \
			((nd).status == ACTIVE || ((nd).status == SLEEP)))
#define IsGuest(nd)			((nd).type == GUEST && \
			((nd).status == ACTIVE || ((nd).status == SLEEP)))
#define IsGod(nd)			((nd).type == GOD && \
			((nd).status == ACTIVE || ((nd).status == SLEEP)))


#ifdef __STDC__
int InitNode(int);
int InitNodes();
int NewNodeIndex();
int NewNode(int, int, char *, char *, char *, char *);
int NumPlayers();
int NumGuests();
int GetNodeType(char *);
char *StrNodeType(int);
int WriteNodes(char *);
char *NodeStat(int);
char *PlayersStat();
char *GuestsStat();
#else
int InitNode();
int InitNodes();
int NewNodeIndex();
int NewNode();
int NumPlayers();
int NumGuests();
int GetNodeType();
char *StrNodeType();
int WriteNodes();
char *NodeStat();
char *PlayersStat();
char *GuestsStat();
#endif

#endif
