/*- FUNCS.C ----------------------------------------------------------------*/
/*- terminate the program reporting an error -------------------------------*/
#include "prottype.h"

void ProgError( char *errstr, ...)
{
   va_list args;

   va_start( args, errstr);
   printf( "\nProgram Error: *** ");
   vprintf( errstr, args);
   printf( " ***\n");
   va_end( args);
   ExitProgram(5);
}

/*- allocate memory with error checking ------------------------------------
 I replaced original malloc and realloc calls with their far
 counterparts because of 'Out of memory' error I got under Windows on large
 WAD -  after this replacement all seemed to work fine - Alex Korobka        */

#if defined(__SMALL__) || defined(__MEDIUM__)
    #error This program requires memory model with FAR DATA pointers
#endif

void *GetMemory(size_t size)
{
   void *ret = farmalloc( size);
   if (!ret)
      ProgError( "Out of memory (cannot allocate %u bytes)", size);
   return ret;
}

/*- reallocate memory with error checking ----------------------------------*/

void *ResizeMemory( void *old, size_t size)
{
   void *ret = farrealloc( old, size);
   if (!ret)
      ProgError( "Out of memory (cannot reallocate %u bytes)", size);
   return ret;
}

/*--------------------------------------------------------------------------*/

